package com.ruov.common.base;

import com.ruov.common.core.domain.AjaxResult;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;

/**
 * ruov Base Controller
 */
public abstract class RController<D extends REntity.Dto, V extends REntity.Vo, P> {

    @Resource
    private RService<D, V, P> service;

    @GetMapping
//    @PreAuthorize("@ss.hasPermi('list')")
    public AjaxResult listData(D query) {
        return AjaxResult.success(service.listData(query));
    }

    @PostMapping
    @PreAuthorize("@ss.hasPermi('inertOrUpdate')")
    public AjaxResult inertOrUpdate(@RequestBody D data) {
        return AjaxResult.success(service.inertOrUpdate(data));
    }

    @DeleteMapping
    @PreAuthorize("@ss.hasPermi('delBatch')")
    public AjaxResult delBatch(List<? extends Serializable> id) {
        return AjaxResult.success(service.delBatch(id));
    }

    @GetMapping("export")
    @PreAuthorize("@ss.hasPermi('export')")
    public AjaxResult export(D query) {
        service.export(query);
        return AjaxResult.success();
    }
}
