package com.ruov.framework.aspectj;

import com.ruov.common.annotation.PreAuthPrefix;
import com.ruov.framework.web.service.PermissionService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(2)
@Component
public class PreAuthPrefixAspect {
    @Pointcut("@annotation(org.springframework.security.access.prepost.PreAuthorize)")
    public void paPointCut() {

    }

    @Around("paPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        if (point.getTarget().getClass().isAnnotationPresent(PreAuthPrefix.class)) {
            PermissionService.PerPrefix(point.getTarget().getClass().getAnnotation(PreAuthPrefix.class).value());
        }
        try {
            return point.proceed();
        } finally {
            PermissionService.PerPrefixClear();
        }
    }

}
